/*
*   \file
*   \remarks Crypto APIs Prototypes
*   \author Pavel Haber
*
*   WMDRM Service Package, Type Definitions, Crypto APIs 
*
*   Copyright (C) 2007 by Discretix Technologies Ltd.
*           All rights reserved.
*
*/

#ifndef CRYPTO_TST_API_H
#define CRYPTO_TST_API_H

DRM_RESULT CRY_PreTestCase(long lTCID, char *strTCName);
DRM_RESULT CRY_PostTestCase(long lTCID, char *strTCName);

DRM_RESULT TestGenRandomData(long argc, char **argv);
DRM_RESULT TestMemComp(long argc, char **argv);
DRM_RESULT TestPKEncrypt_PKDecrypt(long argc, char **argv);
DRM_RESULT TestPKSign_PKVerify(long argc, char **argv);
DRM_RESULT TestDRMCipher_Init(long argc, char **argv);
DRM_RESULT TestDRMCipher_Encrypt(long argc, char **argv);
DRM_RESULT TestDRMCipher_Decrypt(long argc, char **argv);
DRM_RESULT TestShaInit(long argc, char **argv);
DRM_RESULT TestShaUpdate(long argc, char **argv);
DRM_RESULT TestShaDone(long argc, char **argv);
DRM_RESULT TestHMACInit(long argc, char **argv);
DRM_RESULT TestHMACAdd(long argc, char **argv);
DRM_RESULT TestHMACDone(long argc, char **argv);
DRM_RESULT TestDRM_rc4(long argc, char **argv);
DRM_RESULT TestDeskey_Des(long argc, char **argv);
DRM_RESULT TestCBC64WS4_asm(long argc, char **argv);
DRM_RESULT TestInvCBC64WS4_asm(long argc, char **argv);

#endif

